/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.handler;

import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.AwakeningAltarTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import com.blakebr0.mysticalagriculture.tileentity.InfusionAltarTileEntity;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

public final class GuiOverlayHandler {
    @SubscribeEvent
    public void onPostRenderGui(RenderGuiEvent.Post event) {
        EssenceVesselTileEntity vessel;
        ItemStack stack;
        BlockEntity tile;
        HitResult pos;
        BlockHitResult result;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        GuiGraphics gfx = event.getGuiGraphics();
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BaseInventoryTileEntity altar;
            Object recipe;
            result = (BlockHitResult)hitResult;
            pos = result.getBlockPos();
            tile = level.getBlockEntity((BlockPos)pos);
            ItemStack stack2 = ItemStack.EMPTY;
            if (tile instanceof InfusionAltarTileEntity && (recipe = (altar = (InfusionAltarTileEntity)tile).getActiveRecipe()) != null) {
                stack2 = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
            }
            if (tile instanceof AwakeningAltarTileEntity && (recipe = (altar = (AwakeningAltarTileEntity)tile).getActiveRecipe()) != null) {
                stack2 = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
                GuiOverlayHandler.drawEssenceRequirements(gfx, (IAwakeningRecipe)recipe, (AwakeningAltarTileEntity)altar);
            }
            if (!stack2.isEmpty()) {
                int x = mc.getWindow().getGuiScaledWidth() / 2 - 11;
                int y = mc.getWindow().getGuiScaledHeight() / 2 - 8;
                gfx.renderItem(stack2, x + 26, y);
                gfx.renderItemDecorations(mc.font, stack2, x + 26, y);
                gfx.drawString(mc.font, stack2.getHoverName(), x + 48, y + 5, 0xF9FFFE);
            }
        }
        if ((pos = mc.hitResult) instanceof BlockHitResult && (tile = mc.level.getBlockEntity((BlockPos)(pos = (result = (BlockHitResult)pos).getBlockPos()))) instanceof EssenceVesselTileEntity && !(stack = (vessel = (EssenceVesselTileEntity)tile).getInventory().getStackInSlot(0)).isEmpty()) {
            int x = mc.getWindow().getGuiScaledWidth() / 2 - 11;
            int y = mc.getWindow().getGuiScaledHeight() / 2 - 8;
            gfx.renderItem(stack, x + 26, y);
            gfx.renderItemDecorations(mc.font, stack, x + 26, y);
            gfx.drawString(mc.font, stack.getHoverName(), x + 48, y + 5, 0xF9FFFE);
        }
    }

    private static void drawEssenceRequirements(GuiGraphics gfx, IAwakeningRecipe recipe, AwakeningAltarTileEntity altar) {
        Minecraft mc = Minecraft.getInstance();
        int x = mc.getWindow().getGuiScaledWidth() / 2 - 11;
        int y = mc.getWindow().getGuiScaledHeight() / 2 - 4;
        Objects.requireNonNull(mc.font);
        int lineHeight = 9 + 6;
        boolean hasMissingEssences = false;
        int xOffset = 0;
        Map<ItemStack, Integer> missingEssences = recipe.getMissingEssences((List<ItemStack>)altar.getEssenceItems());
        for (Map.Entry<ItemStack, Integer> essence : missingEssences.entrySet()) {
            gfx.renderItem(essence.getKey(), x + 26 + xOffset, y + 2 * lineHeight);
            gfx.drawString(mc.font, GuiOverlayHandler.getEssenceDisplayName(essence.getKey(), essence.getValue()), x + 48 + xOffset, y + 5 + 2 * lineHeight, 0xF9FFFE);
            xOffset += 56;
            hasMissingEssences = true;
        }
        if (hasMissingEssences) {
            gfx.drawString(mc.font, (Component)ModTooltips.MISSING_ESSENCES.build(), x + 28, y + 5 + lineHeight, 0xF9FFFE);
        }
    }

    private static String getEssenceDisplayName(ItemStack stack, int missing) {
        int required = stack.getCount();
        return required - missing + "/" + required;
    }
}

